# SFCファイル形式のVue.jsプログラムの実行方法

拡張子が「.vue」の、SFCファイル形式のVue.jsプログラムを実行するには、 [Node.js](https://nodejs.org/) をインストールする必要があります。
　Node.jsの [公式ダウンロードページ](https://nodejs.org/ja/download) では、Windows、macOS、Linux、AIX向けのインストーラやバイナリパッケージを配布しています。また、それらのOSでの、さまざまなインストール手順も紹介しています。それらに基づいて、各自の環境に合わせた方法で、Node.jsと、Node.jsのパッケージ管理コマンド「npm」をインストールしてください。
　インストールするNode.jsは、バージョン名に長期サポート版を示す「LTS」が付加されているもので、バージョン番号が大きな（つまり新しい）ものにしてください。

## Node.jsとnpmコマンドのインストール後の確認

Node.jsの管理コマンドの「node」や、npmコマンドは、ターミナルで実行します。例えば、nodeコマンドを「-v」オプション付きで次のように実行すると、Node.jsのバージョンが表示されます。

```
$ node -v
v22.19.0
```

　また、npmコマンドを「-v」オプション付きで次のように実行すると、npmのバージョンが表示されます。

```
$ npm -v
10.9.3
```

なお、Windowsでは、npmコマンドの実行時に「npm : このシステムではスクリプトの実行が無効になっているため」から始まるエラーメッセージが表示されて、正しく動作しないことがあります。その場合には、シェルの「PowerShell」が稼働するターミナルを管理者権限で起動して、次のコマンドを実行してください。

```
> Set-ExecutionPolicy RemoteSigned □
```

コマンド実行後、npmコマンドがほかのターミナルでも正しく動作します。

## プロジェクトディレクトリの作成

続いて、Vueアプリケーションを配備するディレクトリ（プロジェクトディレクトリ）を作成します。それには、プロジェクトディレクトリを作成する作業用ディレクトリ（例えば、「~/work」など）に移動してから、次のコマンドを実行します。

```
$ npm create vite@latest
```

「vite@latest」は、「Vite」というビルドツールの最新安定版を利用するための指定です。

コマンドを実行すると、プロジェクト名や、フレームワーク、バリアント（使用する言語など）を聞かれます。ここでは、フレームワークに「Vue」を、バリアントに「JavaScript」を選択します。また、「Use rolldown-vite (Experimental)?:」と「Install with npm and start now?」という質問には「No」と答えてください。

なお、プロジェクト名は、小文字の英数字と数字、ハイフン（-）のみを使ったものにします。スペースや特殊文字、大文字の英字、アンダースコア（_）の使用は非推奨です。

## Vue.jsプログラムの配備

プロジェクトディレクトリを準備できたら、そこに、Vue.jsプログラムを構成する各種ファイルを配備していきます。配布されているプログラムのファイルを、ディレクトリ構成を維持したままコピーしてください。

コピーするのは、実行の起点となるHTMLファイル「index.html」や、Vue.jsプログラムの本体となるSFCファイル「src/App.vue」、メインのJavaScriptファイル「src/main.js」などです。同名のファイルがプロジェクトディレクトリ内にある場合には上書きします。

## パッケージのインストール

プログラムファイルを配備したら、プロジェクトディレクトリ内で「npm install」コマンドを実行して、アプリの稼働に必要なパッケージをインストールします。

例えば、「~/work」ディレクトリ内に作成した「my-proj1」プロジェクトに必要なパッケージをインストールするには、次のようにコマンドを実行します。

```
$ cd ~/work/my-proj1
$ npm install
```

## 開発用Webサーバーの起動

プロジェクトディレクトリで次のコマンドを実行すると、プロジェクトのコードをWebブラウザが理解できる形式に変換し、さらに開発用Webサーバーを起動して、Vue.jsプログラムにWebブラウザでアクセス可能になります。

```
$ npm run dev
```

コマンド実行時に表示されるURL（http://localhost:5173 など）にアクセスすると、Vue.jsプログラムの画面が表示されます。

LAN内のほかのPCからVueアプリケーションにアクセスできるようにするには、次のように「npm run dev」コマンドを実行します。

```
$ npm run dev -- --host
```

開発用Webサーバーを終了するには、「npm run dev」コマンドを実行したターミナルで、［Ctrl］キーを押しながら［C］キーを押します。
